/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.RegistryEntries;

public class ParticleBlurData
implements ParticleOptions {
    public static final ParticleBlurData INSTANCE = new ParticleBlurData(0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
    public static final ParticleOptions.Deserializer<ParticleBlurData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleBlurData>(){

        public ParticleBlurData fromCommand(ParticleType<ParticleBlurData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = (float)reader.readDouble();
            reader.expect(' ');
            float green = (float)reader.readDouble();
            reader.expect(' ');
            float blue = (float)reader.readDouble();
            reader.expect(' ');
            float scale = (float)reader.readDouble();
            reader.expect(' ');
            float ageMultiplier = (float)reader.readDouble();
            return new ParticleBlurData(red, green, blue, scale, ageMultiplier);
        }

        public ParticleBlurData fromNetwork(ParticleType<ParticleBlurData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleBlurData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final Codec<ParticleBlurData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ParticleBlurData::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(ParticleBlurData::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(ParticleBlurData::getBlue), (App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleBlurData::getScale), (App)Codec.FLOAT.fieldOf("ageMultiplier").forGetter(ParticleBlurData::getAgeMultiplier)).apply((Applicative)builder, ParticleBlurData::new));
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;
    private final float ageMultiplier;

    public ParticleBlurData(float red, float green, float blue, float scale, float ageMultiplier) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.scale = scale;
        this.ageMultiplier = ageMultiplier;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_BLUR;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(this.ageMultiplier);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.scale), Float.valueOf(this.ageMultiplier));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getScale() {
        return this.scale;
    }

    public float getAgeMultiplier() {
        return this.ageMultiplier;
    }
}

